# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 2
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR2_strategy.txt
# LLM Suggested Fallback: C

def sunshine_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    total_rounds = len(my_history) + 1
    last_opp_move = opp_history[-1]
    
    # Check for naive opponent patterns
    always_c = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code
    always_d = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code
    
    if always_c:
        return "D"
    if always_d:
        return "D" if total_rounds > 5 else "C"
    
    # Core strategy logic
    if total_rounds >= 9:
        opp_defects = opp_history.count("D")
        return "D" if opp_defects > 2 else "C"
    
    if len(opp_history) >= 2 and opp_history[-2:] == ["D", "D"]:
        return "D"
    
    if last_opp_move == "C":
        return "C"
    else:
        if len(opp_history) >= 3 and opp_history[-3:].count("D") >= 2:
            return "D"
        return last_opp_move